/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IClickListener;
import noppes.npcs.client.gui.custom.interfaces.IDataHolder;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.ICustomScrollListener;

public class CustomGuiScrollComponent
extends GuiCustomScroll
implements IDataHolder,
IClickListener {
    public CustomGuiScrollWrapper component;
    GuiCustom parent;
    private final int[] offsets;

    public CustomGuiScrollComponent(Minecraft mc, ICustomScrollListener parent, int id, CustomGuiScrollWrapper component) {
        super(parent, id, component.isMultiSelect());
        this.field_146297_k = mc;
        this.field_146289_q = mc.field_71466_p;
        this.component = component;
        this.offsets = new int[]{0, 0};
    }

    public void fromComponent(CustomGuiScrollWrapper component) {
        int defaultSelect;
        this.guiLeft = GuiCustom.guiLeft + component.getPosX();
        this.guiTop = GuiCustom.guiTop + component.getPosY();
        this.setSize(component.getWidth(), component.getHeight());
        this.setListNotSorted(Arrays.asList(component.getList()));
        if (component.getDefaultSelection() >= 0 && (defaultSelect = component.getDefaultSelection()) < this.getList().size()) {
            this.selected = defaultSelect;
        }
        if (component.hasHoverText()) {
            this.component.setHoverText(component.getHoverText());
            this.component.setHoverStack(component.getHoverStack());
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int[] getPosXY() {
        return new int[]{this.guiLeft, this.guiTop};
    }

    @Override
    public boolean mouseClicked(GuiCustom gui, int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        return this.isMouseOver(mouseX, mouseY);
    }

    @Override
    public void offSet(int offsetType, double[] windowSize) {
        switch (offsetType) {
            case 1: {
                this.offsets[0] = 0;
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            case 2: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = 0;
                break;
            }
            case 3: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            default: {
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        GlStateManager.func_179094_E();
        int x = this.offsets[0] == 0 ? this.guiLeft : this.offsets[0] - this.guiLeft;
        int y = this.offsets[1] == 0 ? this.guiTop : this.offsets[1] - this.guiTop;
        this.hovered = mouseX >= x && mouseY >= y && mouseX < x + this.field_146294_l && mouseY < y + this.field_146295_m;
        GlStateManager.func_179109_b((float)(x - this.guiLeft), (float)(y - this.guiTop), (float)this.id);
        super.func_73863_a(mouseX, mouseY, (float)mouseWheel);
        if (this.hovered && this.component.hasHoverText()) {
            if (this.component.getHoverText() != null && this.component.getHoverText().length > 0) {
                this.parent.hoverText = this.component.getHoverText();
            }
            if (this.component.getHoverStack() != null && !this.component.getHoverStack().isEmpty()) {
                this.parent.hoverStack = this.component.getHoverStack().getMCItemStack();
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public void setPosXY(int newX, int newY) {
        this.guiLeft = newX;
        this.guiTop = newY;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        List<String> list = this.getList();
        this.component.setList(list.toArray(new String[0]));
        return this.component;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("id", this.id);
        if (!this.getSelectedList().isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (String s : this.getSelectedList()) {
                tagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            nbt.func_74782_a("selectedList", (NBTBase)tagList);
        } else if (this.getSelected() != null && !this.getSelected().isEmpty()) {
            nbt.func_74778_a("selected", this.getSelected());
        } else {
            nbt.func_74778_a("selected", "Null");
        }
        return nbt;
    }
}

